IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'CPJ_Clientes_ResumenCta_Detalle') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE CPJ_Clientes_ResumenCta_Detalle
END
GO

CREATE PROCEDURE CPJ_Clientes_ResumenCta_Detalle @pJsonRecibido VARCHAR(8000)
AS 
SET NOCOUNT ON
/*Parametros*/

DECLARE 	@pFechaDesde			DATETIME,
			@pFechaHasta			DATETIME,
			@pId_Unid_Negocio       VARCHAR(10),
			@pFiltrar_con_saldo     TINYINT,
			@pClientes_activos      TINYINT,
            @pId_Cliente            INT

SET @pId_Unid_Negocio			= ISNULL(CONVERT(VARCHAR(10), dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Unid_Negocio')),'')
SET @pFechaDesde				= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'FechaDesde')),GETDATE())
SET @pFechaHasta				= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'FechaHasta')),GETDATE())
SET @pFiltrar_con_saldo			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Filtrar_con_saldo')),0)
SET @pClientes_activos			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Clientes_activos')),0)
SET @pId_Cliente		    	= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Cliente')),0)

/*Declaracion Variables Locales*/

DECLARE @Mensaje			VARCHAR(100)
		,@UltError			INT
		,@Id_Trans			INT
		,@Importe			DECIMAL(16,2)
		,@Email_Cob			VARCHAR(256)
		,@Id_Trans_Rec		INT
		,@CursorOpen        INT
		,@Flag_Cbte_Tipo	SMALLINT
		,@Periodo           DATE 
		,@Id_sucursal	    SMALLINT
		,@Venta_Total       DECIMAL(16,2)

					
BEGIN 

    SELECT ID_UNID_NEGOCIO INTO #UN FROM Empresas_Unid_Negocios

    IF CAST(@pId_Unid_Negocio as int) <> 0
       DELETE #UN WHERE ID_UNID_NEGOCIO <> @pId_Unid_Negocio 


	CREATE TABLE #ACTIVO (ACTIVO TINYINT)
    INSERT INTO #ACTIVO (ACTIVO) VALUES (1)

	IF @pClientes_activos <> 1
	  INSERT INTO #ACTIVO (ACTIVO) VALUES (0)


		Select F.Fecha,K.Descripcion,F.Fecha_Venc,F.Id_Trans,F.Id_Moneda,F.Cotizacion,F.IMP_TOTAL*f.cotizacion AS Debe,F.IMP_TOTAL AS Haber,F.IMP_TOTAL AS Saldo
		Into #Resumen_Cta
		 from Cbtes_Tipos T, Clientes c, Cbtes F, #UN U, CLIENTES_CTACTE K
		 where C.id_cliente = f.id_cliente
		 AND K.ID_TRANS = F.ID_TRANS
		 AND C.ID_CLIENTE = @pId_Cliente
		 AND T.Id_Unid_Negocio = U.Id_Unid_Negocio
		 and f.id_tipo_cbte = t.id_tipo_cbte
		 and f.Id_Cond_Pago <> 1 and t.Compromete_Factura in (1) 
		 and f.id_estado_cbte not in (0,3)
		 AND F.FECHA >= @pFechaDesde 
	  	 AND F.FECHA < dateadd(dd,1,@pFechaHasta)

 
        UPDATE #Resumen_Cta SET HABER = 0,SALDO = 0

		Select F.FECHA,K.Descripcion,F.Fecha_Venc,F.ID_TRANS,F.ID_MONEDA,F.COTIZACION,0 AS DEBE,F.IMP_TOTAL*f.cotizacion AS HABER,0 AS SALDO
		Into #Resumen_nc
		 from Cbtes_Tipos T, Clientes c, Cbtes F, #UN U, CLIENTES_CTACTE K
		 where C.id_cliente = f.id_cliente
		 AND K.ID_TRANS = F.ID_TRANS
		 AND C.ID_CLIENTE = @pId_Cliente
		 AND T.Id_Unid_Negocio = U.Id_Unid_Negocio
		 and f.id_tipo_cbte = t.id_tipo_cbte
		 and f.Id_Cond_Pago <> 1 and t.Compromete_Factura in (-1) 
		 and f.id_estado_cbte not in (0,3)
		 AND F.FECHA >= @pFechaDesde 
	     AND F.FECHA < dateadd(dd,1,@pFechaHasta)

		Select F.FECHA,K.Descripcion,F.Fecha_Venc,F.ID_TRANS,F.ID_MONEDA,F.COTIZACION,0 AS DEBE,F.IMP_TOTAL*f.cotizacion AS HABER,0 AS SALDO
		Into #Resumen_REC
		 from Cbtes_Tipos T, Clientes c, Cbtes F, #UN U, CLIENTES_CTACTE K
		 where C.id_cliente = f.id_cliente
		 AND K.ID_TRANS = F.ID_TRANS
		 AND C.ID_CLIENTE = @pId_Cliente
		 AND T.Id_Unid_Negocio = U.Id_Unid_Negocio
		 and f.id_tipo_cbte = t.id_tipo_cbte
		 and t.Compromete_Recibos in (1,-1) 
		 and f.id_estado_cbte not in (0,3)
		 AND K.Nro_Cuota = 1
		 AND F.FECHA >= @pFechaDesde 
		 AND F.FECHA < dateadd(dd,1,@pFechaHasta)

        INSERT INTO #Resumen_Cta SELECT * FROM #Resumen_nc
	    INSERT INTO #Resumen_Cta SELECT * FROM #Resumen_Rec
 
		 

		DECLARE @Debe DECIMAL(16,2)
		DECLARE @Haber DECIMAL(16,2)
		DECLARE @Saldo DECIMAL(16,2)

		SET @Saldo = 0
		DECLARE Cur_Saldo CURSOR FOR
			 SELECT Id_Trans,Debe,Haber FROM #Resumen_Cta order by FECHA,ID_TRANS

		OPEN Cur_Saldo 
		FETCH NEXT FROM Cur_Saldo INTO @Id_trans,@debe,@haber
		WHILE @@FETCH_STATUS=0
		BEGIN
			SET @Saldo = @Saldo + @debe - @haber
			UPDATE #Resumen_Cta SET Saldo = @Saldo WHERE Id_trans = @Id_trans
			FETCH NEXT FROM Cur_Saldo INTO @Id_trans,@debe,@haber
		END
		CLOSE Cur_Saldo
		DEALLOCATE Cur_Saldo

		SELECT * FROM #Resumen_Cta ORDER BY FECHA,ID_TRANS


		DROP TABLE #Resumen_Cta
        DROP TABLE #UN
		DROP TABLE #Resumen_nc
		DROP TABLE #ACTIVO
		DROP TABLE #Resumen_Rec
 END

/*

EXEC dbo.CPJ_Clientes_ResumenCta_Detalle   '{
			"FechaDesde":"20210101",
			"FechaHasta":"20210930",
		    "Filtrar_con_saldo":"1",
			"Clientes_activos":"1",
			"Id_Cliente":"52",
			"Id_Unid_Negocio":""
		}'

*/